/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.rftoolsstorage.modules.scanner.client.GuiStorageScanner;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketReturnInventoryInfo {
    private final List<InventoryInfo> inventories;

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            buf.m_130064_(info.pos());
            buf.m_130070_(info.name());
            buf.writeBoolean(info.routable());
            if (info.block() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            String id = info.block().getRegistryName().toString();
            buf.m_130070_(id);
        }
    }

    public PacketReturnInventoryInfo(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.m_130135_();
            String name = buf.m_130136_(Short.MAX_VALUE);
            boolean routable = buf.readBoolean();
            Block block = null;
            if (buf.readBoolean()) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
            }
            this.inventories.add(new InventoryInfo(pos, name, routable, block));
        }
    }

    public PacketReturnInventoryInfo(List<InventoryInfo> inventories) {
        this.inventories = inventories;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GuiStorageScanner.fromServer_inventories = this.getInventories();
        });
        ctx.setPacketHandled(true);
    }

    public record InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
    }
}

